#ifndef SENSOR_H_
#define SENSOR_H_

// Initializes the I2C communication with the sensor
void sensor_initCommunication();

//Initialize the accelerometer
void sensor_initAccel();

//Check if the accelerometer has available data
char sensor_checkAccel(void);

//Read the accelerometer data, all axes
//Needs array of at least 6 elements
void sensor_readAccel(char *dest);

//Read the accelerometer data, x axes
//Needs array of at least 2 elements
void sensor_readAccelX(char *dest);

//Read the accelerometer data, y axes
//Needs array of at least 2 elements
void sensor_readAccelY(char *dest);

//Read the accelerometer data, z axes
//Needs array of at least 2 elements
void sensor_readAccelZ(char *dest);

//Initialize the Gyroscope
void sensor_initGyro();

//Check if the gyroscope has available data
char sensor_checkGyro(void);

//Read the gyroscope data, all axes
//Needs array of at least 6 elements
void sensor_readGyro(char *dest);

//Read the gyroscope data, X axes
//Needs array of at least 2 elements
void sensor_readGyroX(char *dest);

//Read the gyroscope data, Y axes
//Needs array of at least 2 elements
void sensor_readGyroY(char *dest);

//Read the gyroscope data, Z axes
//Needs array of at least 2 elements
void sensor_readGyroZ(char *dest);

//Initialize the Gyroscope
void sensor_initMagn();

//Check if the gyroscope has available data
char sensor_checkMagn(void);

//Read the gyroscope data, all axes
//Needs array of at least 6 elements
void sensor_readMagn(char *dest);

//Read the gyroscope data, X axes
//Needs array of at least 2 elements
void sensor_readMagnX(char *dest);

//Read the gyroscope data, Y axes
//Needs array of at least 2 elements
void sensor_readMagnY(char *dest);

//Read the gyroscope data, Z axes
//Needs array of at least 2 elements
void sensor_readMagnZ(char *dest);

#endif /* SENSOR_H_ */